/* 
 * This program traverses a directory tree and executes
 * dbmail conversion on each file. It creates the necessary
 * mailboxes when they don't exist.
 *
 * The original uni-one-converter was written by the IC&S 
 * (the company developing DBMail). This version is based 
 * on the edited version by Frido Ferdinand <frido@zolder.net>. 
 * Now takes the user name as an argument. 
 * Arto Ters <arto.teras@hip.fi>
 * 
 * Parses a 
 * slightly edited to parse this kind of directory
 *
 * /home/user/mail/box
 * /home/user/mail/lists/mailinglist
 * 
 * create mailbox for each mboxfile (box, lists/mailinglist)
 * use constant for user
 *
 * did not change printf statements, maybe confusing
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>
#include <time.h>
#include <unistd.h>
#include "db.h"
#include "auth.h"
#include "dbmailtypes.h"
#include "debug.h"
#include <regex.h>

#define MAX_LINESIZE 1024
#define UID_SIZE 70

const char *mbox_delimiter_pattern = "^From .* ";
char blk[READ_BLOCK_SIZE + MAX_LINESIZE + 1];

/* syslog */
#define PNAME "dbmail/uni-one-convertor"

char *getusername (char *path);
int traverse (u64_t userid, char *path);
int process_mboxfile(char *file, u64_t userid);



int main (int argc, char* argv[])
{
  time_t start;
  time_t stop;
  int result;
  u64_t userid;

  if (argc != 3)
    {
      printf("Error: Wrong number of arguments\n");
      printf("Usage: uni-one-converter username directory\n");
      printf("Example: uni-one-converter joe /home/joe/mail\n");
      return -1;
    }

  openlog(PNAME, LOG_PID, LOG_MAIL);   /* open connection to syslog */
  configure_debug(TRACE_ERROR, 1, 0);

  /* open dbase connections */
  if (db_connect() != 0 || auth_connect() != 0)
    {
      printf("Error opening dbase connections\n");
      return -1;
    }


  time (&start); /* mark the starting time */

  userid = auth_user_exists(argv[1]);
  if (userid != -1 && userid != 0)
    printf("User %s ok, id [%llu]\n", argv[1], userid);
  else
    {
      printf("User %s doesn't exist. Aborting\n", argv[1]);
      return -1;
    }
  
  result = traverse (userid, argv[2]);
  time (&stop); /* mark the ending time */

  printf ("Conversion started @  %s", ctime(&start));
  printf ("Conversion finished @ %s", ctime(&stop));

  return result;
}

int traverse (u64_t userid, char *path)
{
  char newpath [1024];
  struct dirent **namelist;
  int n;

  n = scandir (path, &namelist, 0, alphasort);

  if (n < 0)
    {
      printf ("file %s\n",path);	         
      printf("converting mailbox...");
      fflush(stdout);
      n = process_mboxfile(path, userid);
      if (n != 0)
	printf("Warning: error converting mailbox\n");
      else
	printf ("done\n");
    }
  else
    {
      while (n--)
        {
	  if ((strcmp(namelist[n]->d_name,"..")!=0) &&
	      (strcmp(namelist[n]->d_name,".")!=0))
            {
	      /* We need to create a mailbox for the plain path too 
	         even though there are no mails. */
	      if (db_findmailbox(path, userid) == 0)
		db_createmailbox(path, userid);
	      sprintf (newpath,"%s/%s",path, namelist[n]->d_name);
	      traverse (userid, newpath);
            }
	  free (namelist[n]);
        }
      free(namelist);
    }
  return 0;
}


int process_mboxfile(char *file, u64_t userid)
{
  regex_t preg;
  int result;
  FILE *infile;
  int in_msg, header_passed;
  char newunique[UID_SIZE];
  unsigned cnt,len,newlines;
  u64_t msgid=0, size;
  char saved;

  char *a, *b;
  int len2;

  // need to make a proper mailboxname from path
  // no idea how to do this properly, never coded c before :)

  /* does the actual searching                              */
  if ((a = strstr(file, "./") ) != 0) {

       /* blindly chop out the unwanted string                */
       /* don't forget the null!                              */
       len2 = strlen("./");
       b = a+len2;
       memcpy(a, b, strlen(b)+1);
  }

  if (db_findmailbox(file, userid) == 0)
    db_createmailbox(file, userid);

  if ((result = regcomp(&preg, mbox_delimiter_pattern, REG_NOSUB)) != 0)
    {
      trace(TRACE_ERROR,"Regex compilation failed.");
      return -1;
    }

  if ( (infile = fopen(file, "r")) == 0)
    {
      
      trace(TRACE_ERROR,"Could not open file [%s]", infile);
      return -1;
    }

  in_msg = 0;
  cnt = 0;
  size = 0;
  newlines = 0;

  while (!feof(infile) && !ferror(infile))
    {
      if (fgets(&blk[cnt], MAX_LINESIZE, infile) == 0)
	break;

      /* check if this is an mbox delimiter */
      if (regexec(&preg, &blk[cnt], 0, NULL, 0) == 0)
	{
	  if (!in_msg)
	    in_msg = 1; /* ok start of a new msg */
	  else
	    {
	      /* update & end message */
	      db_insert_message_block(blk, cnt, msgid);

	      snprintf(newunique, UID_SIZE, "%lluA%lu", userid, time(NULL));
	      db_update_message(msgid, newunique, size+cnt, size+cnt+newlines);
	      trace(TRACE_ERROR, "message [%llu] inserted, [%u] bytes", msgid, size+cnt);
	    }


	  /* start new message */
	  msgid = db_insert_message(userid, file, 0);
	  header_passed = 0;
	  cnt = 0;
	  size = 0;
	  newlines = 0;
	}
      else
	{
	  newlines++;
	  if (header_passed == 0)
	    {
	      /* we're still reading the header */
	      len = strlen(&blk[cnt]);
	      if (strcmp(&blk[cnt], "\n") == 0)
		{
		  db_insert_message_block(blk, cnt+len, msgid);
		  header_passed = 1;
		  size += (cnt+len);
		  cnt = 0;
		}
	      else
		cnt += len;
	    }
	  else
	    {
	      /* this is body data */
	      len = strlen(&blk[cnt]);
	      cnt += len;
	      
	      if (cnt >= READ_BLOCK_SIZE)
		{
		  /* write block */
		  saved = blk[READ_BLOCK_SIZE];

		  blk[READ_BLOCK_SIZE] = '\0';
		  db_insert_message_block(blk, READ_BLOCK_SIZE, msgid);
		  blk[READ_BLOCK_SIZE] = saved;

		  memmove(blk, &blk[READ_BLOCK_SIZE], cnt - (READ_BLOCK_SIZE));
		  size += READ_BLOCK_SIZE;
		  cnt  -= READ_BLOCK_SIZE;
		}
	    }
	}
    }

  /* update & end message */
  if (msgid > 0)
    {
      db_insert_message_block(blk, cnt, msgid);

      snprintf(newunique, UID_SIZE, "%lluA%lu", userid, time(NULL));
      db_update_message(msgid, newunique, size+cnt, size+cnt+newlines);
      trace(TRACE_ERROR, "message [%llu] inserted, [%u] bytes", msgid, size+cnt);
    }

  fclose(infile);
  return 0;
}
