/*
 * dbase driver header file
 * Functions for database communication 
 *
 * should connect to any dbXXX.c file where XXXX is the dbase to be used
 */

#ifndef  _DB_H
#define  _DB_H

#include "debug.h"
#include "dbmailtypes.h"
#include "mime.h"
#include "list.h"
#include "memblock.h"

#include "organize-helpers.h"
#include <bow/libbow.h>

#define DEF_QUERYSIZE 1024
#define DUMP_BUF_SIZE 1024

#define ICHECK_RESULTSETSIZE 1000000

#define MAX_EMAIL_SIZE 250

/* size of the messageblk's */
#define READ_BLOCK_SIZE (512ul*1024ul)		/* be carefull, MYSQL has a limit */

/* config types */
#define CONFIG_MANDATORY 1			
#define CONFIG_EMPTY 0


struct session;
struct list;

/* users, aliases, mailboxes, messages, messageblks */
#define DB_NTABLES 5
    

enum table_aliases /* prototype for aliases table */
{
	ALIASES_ALIAS_IDNR,
	ALIASES_ALIAS,
	ALIASES_USERIDNR
};

enum table_user /* prototype for user table */
{
	USER_USERIDNR,
	USER_USERID,
	USER_PASSWD,
	USER_CLIENTID,
	USER_MAXMAIL
};

enum table_mailbox /* prototype for mailbox table */
{
	MAILBOX_MAILBOXIDNR,
	MAILBOX_OWNERIDNR,
	MAILBOX_NAME,
	MAILBOX_SEEN_FLAG,
	MAILBOX_ANSWERED_FLAG,
	MAILBOX_DELETED_FLAG,
	MAILBOX_FLAGGED_FLAG,
	MAILBOX_RECENT_FLAG,
	MAILBOX_DRAFT_FLAG,
	MAILBOX_NO_INFERIORS,
	MAILBOX_NO_SELECT,
	MAILBOX_PERMISSIONS
};
	
enum table_message /* prototype for message table */
{
	MESSAGE_MESSAGEIDNR,
	MESSAGE_MAILBOXIDNR,
	MESSAGE_MESSAGESIZE,
	MESSAGE_SEEN_FLAG,
	MESSAGE_ANSWERED_FLAG,
	MESSAGE_DELETED_FLAG,
	MESSAGE_FLAGGED_FLAG,
	MESSAGE_RECENT_FLAG,
	MESSAGE_DRAFT_FLAG,
	MESSAGE_UNIQUE_ID,
	MESSAGE_INTERNALDATE,
	MESSAGE_STATUS
};

enum table_messageblk /* prototype for messageblk table */
{
	MESSAGEBLK_MESSAGEBLKNR,
	MESSAGEBLK_MESSAGEIDNR,
	MESSAGEBLK_MESSAGEBLK,
	MESSAGEBLK_BLOCKSIZE
};



/* 
 * PROTOTYPES 
 */

int db_connect();
int db_disconnect();
int db_query (const char *thequery);

char *db_get_config_item (char *item, int type);
int db_clear_config();
int db_insert_config_item (char *item, char *val);

u64_t db_get_quotum_used(u64_t userid);

u64_t db_get_user_from_alias(const char *alias);

int db_get_user_aliases(u64_t userid, struct list *aliases);
int db_addalias(u64_t useridnr, char *alias, u64_t clientid);
int db_addalias_ext(char *alias, char *deliver_to, u64_t clientid);
int db_removealias(u64_t useridnr, const char *alias);
int db_removealias_ext(const char *alias, const char *deliver_to);

u64_t db_get_mailboxid(u64_t useridnr, const char *mailbox);
u64_t db_get_useridnr(u64_t messageidnr);
u64_t db_get_message_mailboxid(u64_t messageidnr);
u64_t db_insert_message(u64_t useridnr, const char *deliver_to_mailbox, const char *uniqueid);
u64_t db_update_message(u64_t messageidnr, const char *unique_id,
			u64_t messagesize, u64_t rfcsize);
int db_update_message_multiple(const char *unique_id, u64_t messagesize, u64_t rfcsize);
u64_t db_insert_message_block(const char *block, u64_t len, u64_t messageidnr);
int db_insert_message_block_multiple(const char *unique_id, const char *block, u64_t len);

int db_rollback_insert(u64_t ownerid, const char *unique_id);

int db_log_ip(const char *ip);
int db_cleanup_iplog(const char *lasttokeep);

int db_cleanup();

int db_empty_mailbox(u64_t userid);

int db_icheck_messageblks(struct list *lostlist);
int db_icheck_messages(struct list *lostlist);
int db_icheck_mailboxes(struct list *lostlist);

int db_delete_messageblk(u64_t uid);
int db_delete_message(u64_t uid);
int db_delete_mailbox(u64_t uid, int only_empty);

u64_t db_insert_result (const char *sequence_identifier);
int db_send_message_lines (void *fstream, u64_t messageidnr, long lines, int no_end_dot);
int db_createsession (u64_t useridnr, struct session *sessionptr);
void db_session_cleanup (struct session *sessionptr);
int db_update_pop (struct session *sessionptr);
u64_t db_set_deleted ();
u64_t db_deleted_purge();
u64_t db_check_sizelimit (u64_t addblocksize, u64_t messageidnr, 
				  u64_t *useridnr);
int db_imap_append_msg(const char *msgdata, u64_t datalen, u64_t mboxid, u64_t uid);

/* mailbox functionality */
u64_t db_findmailbox(const char *name, u64_t useridnr);
int db_findmailbox_by_regex(u64_t ownerid, const char *pattern, 
			    u64_t **children, unsigned *nchildren,
			    int only_subscribed);
int db_getmailbox(mailbox_t *mb, u64_t userid);
int db_createmailbox(const char *name, u64_t ownerid);
int db_listmailboxchildren(u64_t uid, u64_t useridnr, 
			   u64_t **children, int *nchildren,
			   const char *filter);
int db_removemailbox(u64_t uid, u64_t ownerid);
int db_isselectable(u64_t uid);
int db_noinferiors(u64_t uid);
int db_setselectable(u64_t uid, int val);
int db_removemsg(u64_t uid);
int db_movemsg(u64_t to, u64_t from);
int db_copymsg(u64_t msgid, u64_t destmboxid);
int db_getmailboxname(u64_t uid, char *name);
int db_setmailboxname(u64_t uid, const char *name);
int db_expunge(u64_t uid,u64_t **msgids,u64_t *nmsgs);
u64_t db_first_unseen(u64_t uid);
int db_subscribe(u64_t mboxid);
int db_unsubscribe(u64_t mboxid);

/* message functionality */
int db_get_msgflag(const char *name, u64_t msguid, u64_t mailboxuid);
int db_get_msgflag_all(u64_t msguid, u64_t mailboxuid, int *flags);
int db_get_msgflag_all_range(u64_t msguidlow, u64_t msguidhigh, u64_t mailboxuid, 
			     int **flags, unsigned *resultsetlen);
int db_set_msgflag(u64_t msguid, u64_t mailboxuid, int *flags, int action_type);
int db_set_msgflag_range(u64_t msguidlow, u64_t msguidhigh, u64_t mailboxuid, 
			 int *flags, int action_type);

int db_get_msgdate(u64_t mailboxuid, u64_t msguid, char *date);

int db_set_rfcsize(u64_t size, u64_t msguid, u64_t mailboxuid);
u64_t db_get_rfcsize(u64_t msguid, u64_t mailboxuid);
 
/* int db_get_msginfo_range(u64_t msguidlow, u64_t msguidhigh, u64_t mailboxuid,
 *			    int getflags, int getinternaldate, int getsize, int getuid,
 *                          msginfo_t **result, unsigned *resultsetlen);
 */
/* Syntax modified */
int db_get_msginfo_range(u64_t low, u64_t high, mailbox_t *mailbox, int use_uid,
			 int getflags, int getinternaldate, int getsize, int getuid,
			 msginfo_t **result, unsigned *resultsetlen);

int db_get_main_header(u64_t msguid, struct list *hdrlist);

int db_mailbox_msg_match(u64_t mailboxuid, u64_t msguid);


/* Message similarity data */
int db_insert_bow_vocabulary(bow_int4str *map, int *word_counts, u64_t userid);
int db_get_bow_vocabulary(u64_t userid, bow_int4str **map, int **word_counts, int *word_counts_size);
int db_insert_bow_barrel(bow_barrel *barrel, u64_t userid);
int db_get_bow_barrel(u64_t userid, bow_barrel **barrel);
int db_insert_bow_wv(bow_wv *wv, u64_t msguid, u64_t userid, int bow_docid);
int db_get_bow_wv(u64_t msguid, u64_t userid, bow_wv **wv);
int db_insert_bow_di2wv(bow_di2wv *di2wv, doc_msg_map *map, u64_t userid);
int db_get_bow_di2wv(u64_t userid, int strict_bow_docid, bow_di2wv **di2wv, doc_msg_map **map);
int db_getvirtualmailbox(mailbox_t *mb, u64_t *uidlist, int count);

/* FIXME: This is crap, the barrel should be stored properly in the
   database, but this gives me a shortcut to continue with the
   interesting stuff... */
extern char bow_barrel_storage_dir[];

#endif



